const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_masterhtd', {
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    Area: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    PrdType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    ReportType: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    BFGCode: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    ProductName: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    PVersion: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Version: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    CubicalNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    CubicleType: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchNo: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    BatchSize: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Side: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    BLName: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NomHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosActualHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    NomThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosActualThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegThick: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TolPosThick: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    NomDiam: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TolNegActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TolPosActualDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    NomBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosActualBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolNegBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    TolPosBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinValueHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValueHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValueHard: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinValueThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValueThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValueThick: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinValueDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValueDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValueDiam: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MinValueBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValueBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValueBL: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Remark: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    StartDateHard: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDateHard: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    StartDateThick: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDateThick: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    StartDateDiam: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDateDiam: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    StartDateBL: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDateBL: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Unit: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    BatchCompleted: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Nom: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    NMT: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Tol1NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2NegActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol2PosActual: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    Tol1Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol1Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Neg: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Tol2Pos: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    GraphOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    LimitOn: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    MinValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    MaxValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    AvgValue: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    StartDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    EndDate: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    DP: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0
    },
    FinalMinDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalMaxDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    FinalAvgDT: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "00:00:00"
    },
    StdTime: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "NULL"
    },
    Stage: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdLimit1: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    StdLimit2: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "NULL"
    },
    Department: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    Min_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    },
    Max_Per: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "0"
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_masterhtd',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK_tbl_batchsummary_masterhtd",
        unique: true,
        fields: [
          { name: "RepSerNo" },
        ]
      },
    ]
  });
};
